/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.asistente.recap.valores;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.ModeloValores;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.util.UtilMapas;
import ec.gob.sri.dimm.data.impl.DataCatalogos;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.joda.time.LocalDate;

public class ModeloValoresPagoLocal
implements ModeloValores {
    private boolean inicializado;
    private DataCatalogos catalogo;
    private Periodo periodo;
    private static Map<String, ElementoNombreValor<String>> paises = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private static Map<String, ElementoNombreValor<String>> paisesCopia = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private final Map<String, ElementoNombreValor<String>> tiposPago;
    private final Map<String, ElementoNombreValor<String>> tiposRegimenFiscalDelExterior;
    private static Map<String, ElementoNombreValor<String>> paisesRegimenGeneral = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private static Map<Integer, ElementoNombreValor<String>> paraisosFiscales = new TreeMap<Integer, ElementoNombreValor<String>>();
    private final LocalDate fechaDeclarada;

    public ModeloValoresPagoLocal(LocalDate fechaDeclarada) {
        this.fechaDeclarada = fechaDeclarada;
        this.catalogo = new DataCatalogos();
        this.tiposPago = new LinkedHashMap<String, ElementoNombreValor<String>>();
        this.tiposRegimenFiscalDelExterior = new LinkedHashMap<String, ElementoNombreValor<String>>();
    }

    public void inicializar() {
        if (!this.inicializado) {
            this.cargarPaises();
            this.cargarPaisesRegimenGeneral();
            this.cargarTiposDePagos();
            this.cargarTiposRegimenFiscalDelExterior();
            this.cargarParaisosFiscalesPorFechaDeclarada(this.fechaDeclarada);
            this.inicializado = true;
        }
    }

    public void inicializaPeriodo(Periodo periodo) {
        this.periodo = periodo;
    }

    public void limpiarElementosDeMapas() {
        paisesRegimenGeneral.clear();
        paraisosFiscales.clear();
        paisesRegimenGeneral = new LinkedHashMap<String, ElementoNombreValor<String>>();
        paraisosFiscales = new TreeMap<Integer, ElementoNombreValor<String>>();
    }

    private void cargarTiposDePagos() {
        this.tiposPago.clear();
        this.tiposPago.put("01", (ElementoNombreValor<String>)new ElementoNombreValor("PAGO A RESIDENTE / ESTABLECIMIENTO PERMANENTE", (Object)"01"));
        this.tiposPago.put("02", (ElementoNombreValor<String>)new ElementoNombreValor("PAGO A NO RESIDENTE", (Object)"02"));
    }

    private void cargarTiposRegimenFiscalDelExterior() {
        Map tiposRegimenFiscal = UtilCatalogosATS.crearInstancia().obtenerTiposDeRegimenFiscalDelExterior();
        for (Map.Entry item : tiposRegimenFiscal.entrySet()) {
            this.tiposRegimenFiscalDelExterior.put((String)item.getKey(), (ElementoNombreValor<String>)new ElementoNombreValor((String)item.getValue(), (Object)((String)item.getKey())));
        }
    }

    public void cargarPaises() {
        paises.clear();
        paises = this.obtenerPaisesPorCatalogo(true);
        if (paisesCopia.size() < 1) {
            paisesCopia = this.obtenerPaisesPorCatalogo(false);
        }
    }

    public void cargarPaisesRegimenGeneral() {
        paisesRegimenGeneral.clear();
        paisesRegimenGeneral = this.obtenerPaisesPorCatalogo(true);
    }

    private Map<String, ElementoNombreValor<String>> obtenerPaisesPorCatalogo(boolean regimen) {
        TreeSet<ElementoNombreValor<String>> oPaises = new TreeSet<ElementoNombreValor<String>>(this.getComparadorElementoNombreValor());
        LinkedHashMap<String, ElementoNombreValor<String>> mPaises = new LinkedHashMap<String, ElementoNombreValor<String>>();
        Map cPaises = this.catalogo.obtenerPaises();
        for (Map.Entry entry : cPaises.entrySet()) {
            boolean ingresaCombo = true;
            if (regimen) {
                boolean esAnexoHastaPeriodo2025 = this.periodo.isAnexoEnPeriodoHasta(this.periodo.junio2025);
                if (esAnexoHastaPeriodo2025 && "233".equals(entry.getKey())) {
                    ingresaCombo = false;
                }
                if ((esAnexoHastaPeriodo2025 = this.periodo.isAnexoEnPeriodoHasta(this.periodo.agosto2025)) && "118".equals(entry.getKey())) {
                    ingresaCombo = false;
                }
            }
            if (!ingresaCombo) continue;
            oPaises.add((ElementoNombreValor<String>)new ElementoNombreValor((String)entry.getValue(), (Object)((String)entry.getKey())));
        }
        for (ElementoNombreValor elementoNombreValor : oPaises) {
            if (elementoNombreValor.getNombre().equalsIgnoreCase("ecuador")) continue;
            mPaises.put((String)elementoNombreValor.getValor(), (ElementoNombreValor<String>)elementoNombreValor);
        }
        return mPaises;
    }

    public void cargarParaisosFiscalesPorFechaDeclarada(LocalDate fechaDeclarada) {
        paraisosFiscales.clear();
        TreeMap<Integer, ElementoNombreValor<String>> paraisosFiscalesSinOrden = new TreeMap<Integer, ElementoNombreValor<String>>();
        for (Map.Entry paraisoObtenido : UtilCatalogosATS.crearInstancia().obtenerParaisosFiscalesPorFechaDeclarada(fechaDeclarada).entrySet()) {
            for (Map.Entry mapaInterno : ((Map)paraisoObtenido.getValue()).entrySet()) {
                paraisosFiscalesSinOrden.put((Integer)paraisoObtenido.getKey(), (ElementoNombreValor<String>)new ElementoNombreValor(((String)mapaInterno.getValue()).trim(), (Object)((String)mapaInterno.getKey()).trim()));
            }
        }
        paraisosFiscales = paraisosFiscalesSinOrden;
        paraisosFiscales = UtilMapas.ordenarMapaElementoNombreValor(paraisosFiscalesSinOrden, Boolean.FALSE);
    }

    public void encontrarPaisDelParaisoFiscal(String codigoPais) {
        LinkedHashMap<String, ElementoNombreValor<String>> mPaises = new LinkedHashMap<String, ElementoNombreValor<String>>();
        for (Map.Entry<String, ElementoNombreValor<String>> pais : paisesCopia.entrySet()) {
            long codigoNumericoPais = Long.parseLong(pais.getKey());
            if (codigoNumericoPais != Long.parseLong(codigoPais)) continue;
            mPaises.clear();
            mPaises.put(pais.getKey(), pais.getValue());
            break;
        }
        paises.clear();
        paises = mPaises;
    }

    public String obtenerParaisoFiscalDelPais(String codigoPais) {
        String codigoParaiso = null;
        block0: for (Map.Entry paraisoObtenido : UtilCatalogosATS.crearInstancia().obtenerParaisosFiscalesPorFechaDeclarada(this.fechaDeclarada).entrySet()) {
            for (Map.Entry mapaInterno : ((Map)paraisoObtenido.getValue()).entrySet()) {
                if (!((String)mapaInterno.getKey()).equals(codigoPais)) continue;
                codigoParaiso = ((Integer)paraisoObtenido.getKey()).toString();
                continue block0;
            }
        }
        return codigoParaiso;
    }

    public List<ElementoNombreValor<String>> getPaises() {
        return new ArrayList<ElementoNombreValor<String>>(paises.values());
    }

    public List<ElementoNombreValor<String>> getPaisesRegimenGeneral() {
        return new ArrayList<ElementoNombreValor<String>>(paisesRegimenGeneral.values());
    }

    public List<ElementoNombreValor<String>> getTiposPagos() {
        return new ArrayList<ElementoNombreValor<String>>(this.tiposPago.values());
    }

    private Comparator<ElementoNombreValor<String>> getComparadorElementoNombreValor() {
        return new Comparator<ElementoNombreValor<String>>(){

            @Override
            public int compare(ElementoNombreValor<String> e1, ElementoNombreValor<String> e2) {
                return e1.getEtiqueta().compareTo(e2.getEtiqueta());
            }
        };
    }

    public List<ElementoNombreValor<String>> getTiposRegimenFiscalDelExterior() {
        return new ArrayList<ElementoNombreValor<String>>(this.tiposRegimenFiscalDelExterior.values());
    }

    public List<ElementoNombreValor<String>> getParaisosFiscales() {
        return new ArrayList<ElementoNombreValor<String>>(paraisosFiscales.values());
    }

    public ElementoNombreValor<String> obtenerPais(String pais) {
        return StringUtil.isNullOrEmpty((String)pais) ? null : paises.get(pais);
    }

    public ElementoNombreValor<String> obtenerPaisRegimenGeneral(String paisRegimenGeneral) {
        return StringUtil.isNullOrEmpty((String)paisRegimenGeneral) ? null : paisesRegimenGeneral.get(paisRegimenGeneral);
    }

    public ElementoNombreValor<String> obtenerTipoPago(String tipoPago) {
        return StringUtil.isNullOrEmpty((String)tipoPago) ? null : this.tiposPago.get(tipoPago);
    }

    public ElementoNombreValor<String> obtenerTipoRegimenFicalDelExterior(String tipoRegimenFiscalDelExterior) {
        return StringUtil.isNullOrEmpty((String)tipoRegimenFiscalDelExterior) ? null : this.tiposRegimenFiscalDelExterior.get(tipoRegimenFiscalDelExterior);
    }

    public ElementoNombreValor<String> obtenerPaisParaisoFiscal(String paisParaisoFiscal) {
        return StringUtil.isNullOrEmpty((String)paisParaisoFiscal) ? null : paraisosFiscales.get(Integer.parseInt(paisParaisoFiscal));
    }
}

